<?php

/**
 * Plugin Name:       WP-Market Plugin
 * Description:       A plugin for WP-Market.
 * Requires at least: 6.6
 * Requires PHP:      7.4
 * Version:           1.0.0.2
 * Author:            WP-Market
 * Author URI:        https://wp-market.org/
 * License:           GPLv3 or later
 * License URI:       https://www.gnu.org/licenses/gpl-3.0.txt
 * Text Domain:       wp-market-plugin
 */

if (!defined('ABSPATH')) exit;

class WP_Market_Plugin
{

    public function __construct()
    {
        $file_data = get_file_data(__FILE__, ['version' => 'Version']);
        define('WMP_PLUGIN_VERSION', $file_data['version']);

        $file_data = get_file_data(__FILE__, ['plugin_slug' => 'Text Domain']);
        define('WMP_PLUGIN_SLUG', $file_data['plugin_slug']);

        define('WMP_PLUGIN_DIR_PATH', plugin_dir_path(__FILE__));
        define('WMP_PLUGIN_DIR_URL', plugin_dir_url(__FILE__));
        define('WMP_PLUGIN_BASENAME', plugin_basename(__FILE__));

        define('WMP_ACTIVE_THEME', get_template());


        require_once WMP_PLUGIN_DIR_PATH . 'inc/class-activate.php';
        require_once WMP_PLUGIN_DIR_PATH . 'inc/class-utility.php';
        require_once WMP_PLUGIN_DIR_PATH . 'inc/class-option.php'; // after
        if (is_admin()) require_once WMP_PLUGIN_DIR_PATH . 'inc/class-menu.php';

        WMP_Option::init();
        if (is_admin()) WMP_Menu::init();

        // register_activation_hook(__FILE__, ['WMP_Activate', 'plugin_activate']);
        // register_deactivation_hook( __FILE__, ['WMP_Activate', 'plugin_deactivate' ] );
        register_uninstall_hook(__FILE__, ['WMP_Activate', 'plugin_uninstall']);
    }
}

new WP_Market_Plugin;



// $wpmarket_options = get_option('wp_market_activation');
// if (!empty($options[WMP_PLUGIN_SLUG]['token'])) {
// auto updater
require_once plugin_dir_path(__FILE__) . 'lib/plugin-update-checker/plugin-update-checker.php';

$myUpdateChecker = YahnisElsts\PluginUpdateChecker\v5\PucFactory::buildUpdateChecker(
    'https://wp-market.org/wp-update-server/?action=get_metadata&slug=' . WMP_PLUGIN_SLUG,
    plugin_dir_path(__FILE__) . WMP_PLUGIN_SLUG . '.php', //Full path to the main plugin file or functions.php.
    WMP_PLUGIN_SLUG,
);

//     license checker
//     $myUpdateChecker->addQueryArgFilter('wsh_filter_update_checks');
//     function wsh_filter_update_checks($queryArgs)
//     {
//         $wpmarket_options = get_option('wp_market_activation');
//         if (!empty($options[WMP_PLUGIN_SLUG]['token'])) {
//             $queryArgs['token'] = $wpmarket_options[WMP_PLUGIN_SLUG]['token'];
//         }

//         return $queryArgs;
//     }
// }
