<?php

if (!defined('ABSPATH')) exit;


class WMP_Utility
{

    private function __construct() {}


    public static function fArray_merge($old, $new)
    {
        foreach ($old as $key => $val) {
            if (is_array($old[$key])) {
                if (isset($new[$key])) {
                    $array[$key] = self::fArray_merge($old[$key], $new[$key]);
                } else {
                    $array[$key] = $old[$key];
                }
            } else if (isset($new[$key])) {
                $array[$key] = $new[$key];
            } else {
                $array[$key] = $old[$key];
            }
        }

        return $array;
    }


    public static function esc_array($data)
    {
        $data = wp_unslash($data);

        if (is_array($data)) {
            $array = array();
            foreach ($data as $key => $val) {
                if (is_array($val)) {
                    $key = esc_html($key, ENT_QUOTES, 'UTF-8');
                    $array[$key] = self::esc_array($val);
                } else {
                    $key = esc_html($key, ENT_QUOTES, 'UTF-8');
                    $array[$key] = esc_html($val, ENT_QUOTES, 'UTF-8');
                }
            }
            return $array;
        } else {
            return esc_html($data, ENT_QUOTES, 'UTF-8');
        }

        return $data;
    }


    public static function send_curl_url($method, $url, $params = [], $headers = [], $timeout = 30)
    {

        $data = '';

        $args = [
            'timeout' => $timeout,
            'headers' => $headers,
            'sslverify' => false,
        ];

        if (strtoupper($method) === 'POST') {
            $args['body'] = wp_json_encode($params);
            $response = wp_remote_post($url, $args);
        } else if (strtoupper($method) === 'GET') {
            $response = wp_remote_get(add_query_arg($params, $url), $args);
        }

        if (is_wp_error($response)) {
            $data = $response->get_error_message();
        } else {
            $data = $response['body'];
        }

        return $data;
    }
}
