<?php

if (!defined('ABSPATH')) exit;


class WMP_Option
{

    private function __construct() {}


    const OPTION_VER = 'wp_market_version';

    const OPTION_NAME = [
        'activation' => 'wp_market_activation',
    ];

    const WP_MARKERT_CHECK = 'https://wp-market.org/wp-update-server/?action=get_metadata&slug=';


    const NONCE_ACTION = 'wp_market_nonce_action';
    const NONCE_NAME = 'wp_market_nonce_name';


    public static $options_default = [];

    public static $options = null;


    public static function init()
    {
        self::set_options_default();
        self::set_options();


        $version = get_option(self::OPTION_VER);

        if (empty($version)) {

            // install
            update_option(self::OPTION_VER, WMP_PLUGIN_VERSION);
            foreach (self::OPTION_NAME as $option_name => $val) {
                update_option(self::OPTION_NAME[$option_name], self::$options_default[$option_name]);
            }
        } else if (WMP_PLUGIN_VERSION !== $version) {

            // version update
            update_option(self::OPTION_VER, WMP_PLUGIN_VERSION);
        }
    }


    public static function set_options_default()
    {
        self::$options_default['activation'] = [];
    }


    public static function set_options()
    {
        foreach (self::OPTION_NAME as $option_name => $val) {
            $options[$option_name] = get_option(self::OPTION_NAME[$option_name]);
        }
        $options = is_array($options) ? $options : [];
        $options = array_merge(self::$options_default, $options);
        // $options = WMP_Utility::fArray_merge(self::$options_default, $options);
        self::$options = $options;
    }


    public static function update($options)
    {
        foreach (self::OPTION_NAME as $option_name => $val) {
            if (isset($options[$option_name])) {
                update_option(self::OPTION_NAME[$option_name], $options[$option_name]);
                self::$options[$option_name] = $options[$option_name] ? $options[$option_name] : self::$options_default[$option_name];
            }
        }
    }
}
