<?php

if (!defined('ABSPATH')) exit;


class WMP_Menu
{

    private function __construct() {}


    public static $admin_menu_slug = [];


    public static function init()
    {

        self::admin_menu_slug();

        add_action('admin_menu', ['WMP_Menu', 'add_menu_pages']);

        add_filter('plugin_action_links_' . WMP_PLUGIN_BASENAME, function ($actions) {
            $wpmarket_url    = '<a href="https://wp-market.org/ja/" target="_blank" rel="noopener">WP-Market</a>';
            array_unshift($actions, $wpmarket_url);
            $activation_url    = '<a href="admin.php?page=wp_market_activation">ライセンス認証</a>';
            array_unshift($actions, $activation_url);

            return $actions;
        });
    }


    public static function admin_menu_slug()
    {
        self::$admin_menu_slug = [
            'activation' => 'wp_market_activation',
        ];
    }


    public static function add_menu_pages()
    {

        add_menu_page(
            'WP-Market', // page title
            __('WP-Market', 'wp-market-plugin'), // menu name
            'manage_options',
            self::$admin_menu_slug['activation'], // slug
            ['WMP_Menu', 'admin_menu_activation_page'], // template function
            'dashicons-cart', // icon
            89,
        );
        add_submenu_page(
            self::$admin_menu_slug['activation'], // parent slug
            __('ライセンス認証', 'wp-market-plugin'), // page title
            __('ライセンス認証', 'wp-market-plugin'), // menu name
            'manage_options',
            self::$admin_menu_slug['activation'], // slug
            ['WMP_Menu', 'admin_menu_activation_page'], // template function
        );
    }


    public static function admin_menu_activation_page()
    {
        require_once WMP_PLUGIN_DIR_PATH . 'inc/admin/activation.php';
    }


    public static function updated_message($updated)
    {
?>
        <div class="notice notice-success settings-success is-dismissible">
            <p>
                <?php echo wp_kses_post($updated); ?>
            </p>
        </div>
    <?php
    }


    public static function error_message($error)
    {
    ?>
        <div class="notice notice-error settings-error is-dismissible">
            <p>
                <?php echo wp_kses_post($error); ?>
            </p>
        </div>
<?php
    }
}
