<?php

if (!defined('ABSPATH')) exit;


$current_option = 'activation';


if (isset($_POST['option_name'])) {

    if (!isset($_POST[WMP_Option::NONCE_NAME]) || !wp_verify_nonce(sanitize_text_field(wp_unslash($_POST[WMP_Option::NONCE_NAME])), WMP_Option::NONCE_ACTION)) wp_die();

    $option_name = isset($_POST['option_name']) ? sanitize_text_field(wp_unslash($_POST['option_name'])) : '';
    unset($_POST['option_name']);

    if (WMP_Option::OPTION_NAME[$current_option] !== $option_name) {

        wp_die();
    }

    $options = WMP_Utility::esc_array($_POST);

    // send license api
    foreach ($options[$current_option] as $plugin_slug => $val) {
        // when empty to input
        // if (!empty($val['license_key']) && false === strpos($val['license_key'], '**********') && (empty(WMP_Option::$options[$current_option][$plugin_slug]['license_key']) || $val['license_key'] !== WMP_Option::$options[$current_option][$plugin_slug]['license_key'])) {
        if (!empty($val['license_key']) && false === strpos($val['license_key'], '**********')) {
            $url = 'https://wp-market.org/wp-json/' . 'lmfwc/v2/licenses/activate/' . $val['license_key'];
            $params = ['slug' => $plugin_slug];
            $username = 'ck_dab8075f934fd2323368a54adad60ead918a12be';
            $password = 'cs_325570f2c6ca8c989d2962b720161eece9a56dd0';
            $headers = ['Authorization' => 'Basic ' . base64_encode("{$username}:{$password}")];
            $json = WMP_Utility::send_curl_url('GET', $url, $params, $headers);
            $object = json_decode($json, false);
            if (isset($object->message)) {
                $error = $object->message;
            } else if (isset($object->success)) {
                if (isset($object->data->activationData->token)) {
                    $options[$current_option][$plugin_slug]['token_id'] = $object->data->activationData->token;
                } else if (isset($object->data->errors->lmfwc_rest_data_error)) {
                    $error = reset($object->data->errors->lmfwc_rest_data_error);
                } else {
                    $error = 'トークンIDを取得できませんでした。';
                }
            } else {
                $error = '不明なエラー';
            }
        }
    }

    foreach ($options[$current_option] as $plugin_slug => $val) {
        // remove token_id when license_key is empty
        if (empty($options[$current_option][$plugin_slug]['license_key'])) {
            $options[$current_option][$plugin_slug]['token_id'] = '';
        }
        // hide license key
        if (isset($options[$current_option][$plugin_slug]['license_key']) && false !== strpos($options[$current_option][$plugin_slug]['license_key'], '**********')) {
            $options[$current_option][$plugin_slug]['license_key'] = WMP_Option::$options[$current_option][$plugin_slug]['license_key'];
        }
    }

    if (!isset($error) && !isset($updated)) {

        WMP_Option::update($options);

        $updated = __('設定を保存しました。', 'ai-direct-editor');
    }
}


$plugins = [];
$active_plugins = get_option('active_plugins');
foreach ($active_plugins as $plugin) {

    $plugin_path = WP_CONTENT_DIR . '/plugins/' . $plugin;

    if (file_exists($plugin_path)) {
        $content = file_get_contents($plugin_path);
        if (false !== stripos($content, WMP_Option::WP_MARKERT_CHECK)) {
            $file_data = get_file_data($plugin_path, ['plugin_slug' => 'Text Domain', 'plugin_name' => 'Plugin Name']);
            $plugin_slug = $file_data['plugin_slug'];
            $license_key = isset(WMP_Option::$options[$current_option][$plugin_slug]['license_key']) ? WMP_Option::$options[$current_option][$plugin_slug]['license_key'] : '';
            $license_key = !empty(WMP_Option::$options[$current_option][$plugin_slug]['license_key']) ? '****************************************' : '';
            $token_id = isset(WMP_Option::$options[$current_option][$plugin_slug]['token_id']) ? WMP_Option::$options[$current_option][$plugin_slug]['token_id'] : '';
            // $token_id = substr($token_id, 0, 12);
            if (WMP_PLUGIN_SLUG !== $file_data['plugin_slug']) {
                $plugins[] = array_merge($file_data, ['license_key' => $license_key, 'token_id' => $token_id]);
            }
        }
    }
}


// $lang = get_locale();

// var_dump(get_option("wp_market_activation"));
?>
<div class="wrap">
    <h1>
        WP-Market
    </h1>
    <?php if (isset($error))  WMP_Menu::error_message($error); ?>
    <?php if (isset($updated))  WMP_Menu::updated_message($updated); ?>
    <h2>WP-Market公式サイト</h2>
    <p><a href="https://wp-market.org/" target="_blank" rel="noopener">https://wp-market.org/</a></p>
    <hr>
    <h2>ライセンス認証</h2>
    <p>「WPMARKET-」から始まるライセンスキーを入力してください。</p>
    <form action="" method="post" accept-charset="UTF-8">
        <?php
        wp_nonce_field(WMP_Option::NONCE_ACTION, WMP_Option::NONCE_NAME);

        ?>
        <?php if (!empty($plugins)) : ?>
            <?php foreach ($plugins as $plugin) : ?>
                <h3><?php echo esc_attr($plugin['plugin_name']) ?></h3>
                <table class="form-table" role="presentation">
                    <tbody>
                        <tr>
                            <th scope="row">
                                ライセンスキー
                            </th>
                            <td>
                                <input type="text" minlength="44" maxlength="44" size="50" name="<?php echo esc_attr($current_option) ?>[<?php echo esc_attr($plugin['plugin_slug']) ?>][license_key]" id="<?php echo esc_attr($plugin['plugin_slug']) ?>_license_key" value="<?php echo esc_attr($plugin['license_key']) ?>">
                            </td>
                            <th scope="row">
                                トークンID
                            </th>
                            <td>
                                <input type="hidden" name="<?php echo esc_attr($current_option) ?>[<?php echo esc_attr($plugin['plugin_slug']) ?>][token_id]" value="<?php echo esc_attr($plugin['token_id']) ?>">
                                <input type="text" id="<?php echo esc_attr($plugin['plugin_slug']) ?>_token_id" value="<?php echo esc_attr(substr($plugin['token_id'], 0, 12)) ?>" readonly>
                            </td>
                        </tr>
                    </tbody>
                </table>
                <hr>
            <?php endforeach; ?>
        <?php else: ?>
            <p>ライセンス認証に対応したプラグインが見つかりませんでした。</p>
        <?php endif; ?>
        <input type="hidden" name="option_name" value="<?php echo esc_attr(WMP_Option::OPTION_NAME[$current_option]); ?>">
        <p class="submit">
            <button type="submit" class="button button-primary"><?php echo esc_html__('変更を保存', 'wp-market-plugin') ?></button>
        </p>
    </form>
</div>